/* - LCDAttachListener -
 * We will display the attach status and the attached TextLCD device's details.
 * We will also enable the fields used to manipulate the TextLCD as well as do 
 * some initializing of ranges and maximum values for some of these fields
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.*;
import com.phidgets.event.*;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import misc.TextFieldLimiter;

public class LCDAttachListener implements AttachListener {
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField dispTxt1;
    private JTextField dispTxt2;
    private JButton clearBtn;
    private JCheckBox backlightChk;
    private JCheckBox cursorChk;
    private JCheckBox blinkChk;
    private JCheckBox customChk;
    private JSlider contrastSlide;
    
    /** Creates a new instance of LCDAttachListener */
    public LCDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField dispTxt1,
            JTextField dispTxt2, JButton clearBtn, JCheckBox backlightChk,
            JCheckBox cursorChk, JCheckBox blinkChk, JCheckBox customChk,
            JSlider contrastSlide)
    {
       this.appFrame = appFrame;
       this.attachedTxt = attachedTxt;
       this.nameTxt = nameTxt;
       this.serialTxt = serialTxt;
       this.versionTxt = versionTxt;
       this.dispTxt1 = dispTxt1;
       this.dispTxt2 = dispTxt2;
       this.clearBtn = clearBtn;
       this.backlightChk = backlightChk;
       this.cursorChk = cursorChk;
       this.blinkChk = blinkChk;
       this.customChk = customChk;
       this.contrastSlide = contrastSlide;
    }

    public void attached(AttachEvent ae) {
        try
        {
            if(ae.getSource().getDeviceType().equals("PhidgetTextLCD"))
            {
                TextLCDPhidget attached = (TextLCDPhidget)ae.getSource();
                attachedTxt.setText(Boolean.toString(attached.isAttached()));
                nameTxt.setText(attached.getDeviceName());
                serialTxt.setText(Integer.toString(attached.getSerialNumber()));
                versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
                dispTxt1.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt1.setEnabled(true);
                dispTxt2.setDocument(new TextFieldLimiter(attached.getColumnCount()));
                dispTxt2.setEnabled(true);
                clearBtn.setEnabled(true);
                backlightChk.setSelected(attached.getBacklight());
                backlightChk.setEnabled(true);
                cursorChk.setSelected(attached.getCursor());
                cursorChk.setEnabled(true);
                blinkChk.setSelected(attached.getCursorBlink());
                blinkChk.setEnabled(true);
                customChk.setEnabled(true);
                contrastSlide.setEnabled(true);
                contrastSlide.setMaximum(255);
                contrastSlide.setMinimum(0);
                contrastSlide.setValue(attached.getContrast());
            }
            else
            {
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                dispTxt1.setText("");
                dispTxt1.setEnabled(false);
                dispTxt2.setText("");
                dispTxt2.setEnabled(false);
                clearBtn.setEnabled(false);
                backlightChk.setEnabled(false);
                cursorChk.setEnabled(false);
                blinkChk.setEnabled(false);
                customChk.setEnabled(false);
                contrastSlide.setEnabled(false);
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
